/*:
 * @plugindesc スタンドアロン時、GameEndメニューにシャットダウンを追加
 * 
 * @author LefTonbo
 *
 * @param Shutdown Text
 * @desc ゲームを閉じるメニューのテキスト
 * @default シャットダウン
 *
 * @param Shutdown SE Name
 * @type file
 * @dir audio/se/
 * @require 1
 * @desc シャットダウン時に鳴らすSE
 * @default 
 *
 * @param Shutdown SE Volume
 * @type number
 * @desc シャットダウン時に鳴らすSEの音量
 * @default 90
 *
 * @param Shutdown SE Pitch
 * @type number
 * @desc シャットダウン時に鳴らすSEのピッチ
 * @default 100
 *
 * @help
 * 次の条件を満たす時、シャットダウンの項目をゲーム終了画面に追加します。
 * ・スタンドアロン
 * ・あるいは、ブラウザではないモバイルプレイ
 *
 * ついでにシャットダウン音を鳴らす機能付き。
 *
 */

//=============================================================================

var Imported = Imported || {};
Imported.LP_ShutdownMenu = true;

var LeftPlugin = LeftPlugin || {};

LeftPlugin.Parameters = PluginManager.parameters('LP_ShutdownMenu');
LeftPlugin.Param = LeftPlugin.Param || {};

LeftPlugin.Param.ShutdownText = String(LeftPlugin.Parameters['Shutdown Text']);
LeftPlugin.Param.ShutdownSEName = String(LeftPlugin.Parameters['Shutdown SE Name']);
LeftPlugin.Param.ShutdownSEVolume = Number(LeftPlugin.Parameters['Shutdown SE Volume']);
LeftPlugin.Param.ShutdownSEPitch = Number(LeftPlugin.Parameters['Shutdown SE Pitch']);

//=============================================================================

(function(){

//=============================================================================
// Scene_GameEnd
//=============================================================================

var _Scene_GameEnd_createCommandWindow = Scene_GameEnd.prototype.createCommandWindow;
Scene_GameEnd.prototype.createCommandWindow = function() {
  _Scene_GameEnd_createCommandWindow.call(this);
  this._commandWindow.setHandler('shutdown', this.commandShutdown.bind(this));
};

Scene_GameEnd.prototype.commandShutdown = function() {
  this.fadeOutAll();
  SceneManager.exit();
};

//=============================================================================
// Window_Command
//=============================================================================

Window_Command.prototype.addCommandAt = function(index, name, symbol, en, ext) {
    if (en === undefined) enabled = true;
    if (ext === undefined) ext = null;
    var obj = { name: name, symbol: symbol, enabled: en, ext: ext};
    this._list.splice(index, 0, obj);
};

//=============================================================================
// Window_GameEnd
//=============================================================================

var _Window_GameEnd_makeCommandList = Window_GameEnd.prototype.makeCommandList;
Window_GameEnd.prototype.makeCommandList = function() {
  _Window_GameEnd_makeCommandList.call(this);
  if (Utils.isNwjs() || (Utils.isMobileDevice() && !Utils.isMobileChrome() && !Utils.isMobileSafari())) {
    var index = this.findSymbol('toTitle');
    this.addCommandAt(index + 1, LeftPlugin.Param.ShutdownText, 'shutdown', true);
  }
};

var _Window_GameEnd_playOkSound = Window_GameEnd.prototype.playOkSound;
Window_GameEnd.prototype.playOkSound = function() {
  var symbol = this.currentSymbol();
  if (symbol === 'shutdown' && LeftPlugin.Param.ShutdownSEName !== '') {
    this.playShutdown();
  } else {
    _Window_GameEnd_playOkSound.call(this);
  }
};

Window_GameEnd.prototype.playShutdown = function() {
  if (LeftPlugin.Param.ShutdownSEName === '') return;
  var sound = {
    name:   LeftPlugin.Param.ShutdownSEName,
    volume: LeftPlugin.Param.ShutdownSEVolume,
    pitch:  LeftPlugin.Param.ShutdownSEPitch,
    pan:    0
  };
  AudioManager.playSe(sound);
};

var _Window_GameEnd_drawItem = Window_GameEnd.prototype.drawItem;
Window_GameEnd.prototype.drawItem = function(index) {
  if (this.commandSymbol(index) !== 'cancel') {
    var rect = this.itemRectForText(index);
    var text = this.commandName(index);
    this.changeTextColor(this.textColor(10));
    this.changePaintOpacity(this.isCommandEnabled(index));
    this.drawText(text, rect.x, rect.y, rect.width, 'center');
  } else {
    _Window_GameEnd_drawItem.call(this, index);
  }
};

//=============================================================================

}());

// EOF
